"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const swagger_1 = require("@nestjs/swagger");
const jwt_auth_guard_1 = __importDefault(require("../../common/guards/jwt-auth.guard"));
const roles_guard_1 = __importDefault(require("../../common/guards/roles.guard"));
const roles_decorator_1 = require("../../common/decorators/roles.decorator");
const upload_service_1 = require("./upload.service");
const upload_response_dto_1 = require("./dto/upload-response.dto");
const multer_config_1 = require("../../config/multer.config");
let UploadController = class UploadController {
    uploadService;
    vendorsService;
    constructor(uploadService) {
        this.uploadService = uploadService;
    }
    async uploadLogo(req, file) {
        if (!file) {
            throw new common_1.BadRequestException('No file uploaded');
        }
        const vendorId = req.user.vendorId || req.user.id;
        const fileUrl = await this.uploadService.saveVendorLogo(vendorId, file.filename);
        return {
            url: fileUrl,
            filename: file.filename,
            originalname: file.originalname,
            size: file.size,
            mimetype: file.mimetype,
            uploadedAt: new Date(),
        };
    }
    async uploadProductImage(req, productId, file) {
        if (!file) {
            throw new common_1.BadRequestException('No file uploaded');
        }
        const vendorId = req.user.vendorId || req.user.id;
        const fileUrl = await this.uploadService.saveProductImage(vendorId, productId, file.filename);
        return {
            url: fileUrl,
            filename: file.filename,
            originalname: file.originalname,
            size: file.size,
            mimetype: file.mimetype,
            uploadedAt: new Date(),
        };
    }
    async uploadDocument(req, file) {
        if (!file) {
            throw new common_1.BadRequestException('No file uploaded');
        }
        const fileUrl = `/uploads/vendors/${file.filename}`;
        return {
            url: fileUrl,
            filename: file.filename,
            originalname: file.originalname,
            size: file.size,
            mimetype: file.mimetype,
            uploadedAt: new Date(),
        };
    }
    async deleteLogo(req) {
        const vendorId = req.user.vendorId || req.user.id;
        const vendor = await this.vendorsService.findOne(vendorId);
        if (vendor.logo) {
            await this.uploadService.deleteFile(vendor.logo);
            await this.vendorsService.update(vendorId, { logo: null });
        }
        return { message: 'Logo deleted successfully' };
    }
    async getLogo(req) {
        const vendorId = req.user.vendorId || req.user.id;
        const vendor = await this.vendorsService.findOne(vendorId);
        return { logoUrl: vendor.logo || null };
    }
};
exports.UploadController = UploadController;
__decorate([
    (0, common_1.Post)('logo'),
    (0, swagger_1.ApiOperation)({ summary: 'Upload vendor logo' }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'Logo uploaded successfully', type: upload_response_dto_1.UploadResponseDto }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Invalid file type or size' }),
    (0, swagger_1.ApiResponse)({ status: 401, description: 'Unauthorized' }),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    (0, swagger_1.ApiBody)({
        schema: {
            type: 'object',
            properties: {
                file: {
                    type: 'string',
                    format: 'binary',
                    description: 'Logo image file (jpg, jpeg, png, gif, webp) max 5MB',
                },
            },
        },
    }),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file', multer_config_1.imageStorageConfig)),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], UploadController.prototype, "uploadLogo", null);
__decorate([
    (0, common_1.Post)('products/:id/image'),
    (0, swagger_1.ApiOperation)({ summary: 'Upload product image' }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'Product image uploaded successfully', type: upload_response_dto_1.UploadResponseDto }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Invalid file type or size' }),
    (0, swagger_1.ApiResponse)({ status: 401, description: 'Unauthorized' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Product not found' }),
    (0, swagger_1.ApiParam)({ name: 'id', type: Number, description: 'Product ID' }),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    (0, swagger_1.ApiBody)({
        schema: {
            type: 'object',
            properties: {
                file: {
                    type: 'string',
                    format: 'binary',
                    description: 'Product image file (jpg, jpeg, png, gif, webp) max 5MB',
                },
            },
        },
    }),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file', multer_config_1.imageStorageConfig)),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __param(2, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Number, Object]),
    __metadata("design:returntype", Promise)
], UploadController.prototype, "uploadProductImage", null);
__decorate([
    (0, common_1.Post)('documents'),
    (0, swagger_1.ApiOperation)({ summary: 'Upload vendor documents' }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'Document uploaded successfully', type: upload_response_dto_1.UploadResponseDto }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Invalid file type or size' }),
    (0, swagger_1.ApiResponse)({ status: 401, description: 'Unauthorized' }),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    (0, swagger_1.ApiBody)({
        schema: {
            type: 'object',
            properties: {
                file: {
                    type: 'string',
                    format: 'binary',
                    description: 'Document file (pdf, doc, docx, txt) max 10MB',
                },
            },
        },
    }),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file', multer_config_1.documentStorageConfig)),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], UploadController.prototype, "uploadDocument", null);
__decorate([
    (0, common_1.Delete)('logo'),
    (0, swagger_1.ApiOperation)({ summary: 'Delete vendor logo' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Logo deleted successfully' }),
    (0, swagger_1.ApiResponse)({ status: 401, description: 'Unauthorized' }),
    __param(0, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UploadController.prototype, "deleteLogo", null);
__decorate([
    (0, common_1.Get)('logo'),
    (0, swagger_1.ApiOperation)({ summary: 'Get vendor logo URL' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Logo URL retrieved successfully' }),
    (0, swagger_1.ApiResponse)({ status: 401, description: 'Unauthorized' }),
    __param(0, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UploadController.prototype, "getLogo", null);
exports.UploadController = UploadController = __decorate([
    (0, swagger_1.ApiTags)('Vendor Upload'),
    (0, common_1.Controller)('vendor/upload'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.default, roles_guard_1.default),
    (0, roles_decorator_1.Roles)('vendor'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [upload_service_1.UploadService])
], UploadController);
//# sourceMappingURL=upload.controller.js.map